<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\Groups;

/**
 * GroupsSearch represents the model behind the search form about `common\models\Groups`.
 */
class GroupsSearch extends Groups
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'l86', 'l64', 'b86', 'b64'], 'integer'],
            [['group', 'l86_created_at', 'l86_version', 'b86_created_at', 'b86_version', 'b64_created_at', 'b64_version', 'l64_created_at', 'l64_version', 'created_at'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $accessFilter = json_decode(Yii::$app->user->identity->groups);

        $query = Groups::find();

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $query->andFilterWhere(['group' => $accessFilter]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere([
            'id' => $this->id,
            'l86_created_at' => $this->l86_created_at,
            'b86_created_at' => $this->b86_created_at,
            'l86' => $this->l86,
            'l64' => $this->l64,
            'b86' => $this->b86,
            'b64' => $this->b64,
            'b64_created_at' => $this->b64_created_at,
            'l64_created_at' => $this->l64_created_at,
            'created_at' => $this->created_at,
        ]);

        $query->andFilterWhere(['like', 'group', $this->group])
            ->andFilterWhere(['like', 'l86_version', $this->l86_version])
            ->andFilterWhere(['like', 'b86_version', $this->b86_version])
            ->andFilterWhere(['like', 'b64_version', $this->b64_version])
            ->andFilterWhere(['like', 'l64_version', $this->l64_version]);

        return $dataProvider;
    }
}
